//
//  CRShadowMixer.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 04/01/10.
//  Copyright 2009 Corner-A. All rights reserved.
//

#import "CRImageProcessor.h"
#import "CRShadowGenerator.h"

extern NSString* const CRShadowMixerBackgroundImageKey;

//////////////////////////////////////////////////////////////////////
// Auxilliary class
// Mixes bottom image and the top one with a shadow from the top image
//////////////////////////////////////////////////////////////////////
@interface CRShadowMixer : CRImageProcessor
{
	CRShadowGenerator* shadow;
}

@property (nonatomic, copy)		CIImage*			inputBackgroundImage;
@property (nonatomic, readonly) CRShadowGenerator*	shadow;

+ (CRShadowMixer *)mixer;

@end